/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.UUID;
import net.minecraft.class_11560;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.command.ConfigCommandUtil;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.api.PlayerConfigType;
import xaero.pac.common.server.player.config.sub.PlayerSubConfigDeletionStarter;
import xaero.pac.common.server.player.data.ServerPlayerData;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class ConfigSubDeleteCommand {
    public void register(CommandDispatcher<class_2168> dispatcher, class_2170.class_5364 environment) {
        Command<class_2168> regularExecutor = ConfigSubDeleteCommand.getExecutor(PlayerConfigType.PLAYER);
        Command<class_2168> serverExecutor = ConfigSubDeleteCommand.getExecutor(PlayerConfigType.SERVER);
        SuggestionProvider<class_2168> playerSubConfigSuggestionProvider = ConfigCommandUtil.getSubConfigSuggestionProvider(PlayerConfigType.PLAYER);
        SuggestionProvider<class_2168> serverSubConfigSuggestionProvider = ConfigCommandUtil.getSubConfigSuggestionProvider(PlayerConfigType.SERVER);
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac").then(class_2170.method_9247((String)"player-config").then(this.getMainCommandPart(playerSubConfigSuggestionProvider, regularExecutor)));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac").then(class_2170.method_9247((String)"player-config").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"for").requires(sourceStack -> class_2170.field_31839.method_75022(sourceStack.method_75037()))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).then(this.getMainCommandPart(playerSubConfigSuggestionProvider, regularExecutor)))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"server-claims-config").requires(sourceStack -> class_2170.field_31839.method_75022(sourceStack.method_75037()))).then(this.getMainCommandPart(serverSubConfigSuggestionProvider, serverExecutor)));
        dispatcher.register(command);
    }

    private LiteralArgumentBuilder<class_2168> getMainCommandPart(SuggestionProvider<class_2168> subConfigSuggestionProvider, Command<class_2168> executor) {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)"sub").then(class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"sub-id", (ArgumentType)StringArgumentType.word()).suggests(subConfigSuggestionProvider).executes(executor)));
    }

    private static Command<class_2168> getExecutor(PlayerConfigType type) {
        return context -> {
            UUID configPlayerUUID;
            class_3222 sourcePlayer = ((class_2168)context.getSource()).method_9207();
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            String inputSubId = StringArgumentType.getString((CommandContext)context, (String)"sub-id");
            class_11560 inputPlayer = null;
            if (type == PlayerConfigType.PLAYER) {
                inputPlayer = ConfigCommandUtil.getConfigInputPlayer((CommandContext<class_2168>)context, sourcePlayer, "gui.xaero_pac_config_delete_sub_too_many_targets", "gui.xaero_pac_config_delete_sub_invalid_target", adaptiveLocalizer);
                if (inputPlayer == null) {
                    return 0;
                }
                configPlayerUUID = inputPlayer.comp_4422();
            } else {
                configPlayerUUID = PlayerConfig.SERVER_CLAIM_UUID;
            }
            ServerPlayerData playerData = (ServerPlayerData)ServerPlayerData.from(sourcePlayer);
            if (serverData.getServerTickHandler().getTickCounter() == playerData.getLastSubConfigCreationTick()) {
                return 0;
            }
            playerData.setLastSubConfigCreationTick(serverData.getServerTickHandler().getTickCounter());
            PlayerConfig playerConfig = (PlayerConfig)serverData.getPlayerConfigs().getLoadedConfig(configPlayerUUID);
            IPlayerConfig result = playerConfig.getSubConfig(inputSubId);
            if (result == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_delete_sub_not_exist", new Object[0]));
                return 0;
            }
            if (result == playerConfig) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_delete_sub_cant_main", new Object[0]));
                return 0;
            }
            IServerPlayerClaimInfo playerInfo = (IServerPlayerClaimInfo)serverData.getServerClaimsManager().getPlayerInfo(configPlayerUUID);
            if (playerInfo.hasReplacementTasks()) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_delete_sub_already_replacing", new Object[0]));
                return 0;
            }
            new PlayerSubConfigDeletionStarter().start(sourcePlayer, playerInfo, result, serverData);
            return 1;
        };
    }
}

